/*
	File:		UtilityWindow.h

	Contains:	Utility window tester class.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef _UTILITYWINDOW_H
#define _UTILITYWINDOW_H

#include <Controls.h>
#include "BaseWindow.h"
#include "Appearance.h"

class UtilityWindow : public BaseWindow
{
	public:
			UtilityWindow();
		virtual ~UtilityWindow();
		
		virtual void		Activate( EventRecord& event );
		virtual void		Deactivate( EventRecord& event );
		virtual void		Draw();
		virtual void		Resize( SInt16 width, SInt16 height );
		virtual void		HandleClick( EventRecord& event );

	protected:
			UtilityWindow( SInt16 windID );
		
	private:
		virtual void		InvalidateScrollBars();
		virtual void		CalcHorizScrollBarRect( Rect& rect );
		virtual void		CalcVertScrollBarRect( Rect& rect );
	
		static pascal void	ScrollBarAction( ControlHandle control, SInt16 partHit );

		ControlHandle		fHorizScrollBar;
		ControlHandle		fVertScrollBar;
};

#endif // _UTILITYWINDOW_H
